<?php
// announcement.php

include('../includes/db.php');
include('../includes/header.php');
include('../includes/navbar.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'admin') {
    header("Location: ../public/login.php");
    exit();
}

// Handle announcement creation
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $title = $_POST['title'];
    $message = $_POST['message'];

    $stmt = $pdo->prepare("INSERT INTO announcements (title, message, created_at) VALUES (:title, :message, NOW())");
    $stmt->execute(['title' => $title, 'message' => $message]);

    $success = "Announcement created successfully.";
}

// Fetch all announcements
$stmt = $pdo->prepare("SELECT * FROM announcements ORDER BY created_at DESC");
$stmt->execute();
$announcements = $stmt->fetchAll();

?>

<div class="container mt-5">
    <h1>Create Announcement</h1>
    <?php if (isset($success)) echo "<div class='alert alert-success'>$success</div>"; ?>
    <form method="POST" action="">
        <div class="form-group">
            <label for="title">Title:</label>
            <input type="text" name="title" class="form-control" required>
        </div>
        <div class="form-group">
            <label for="message">Message:</label>
            <textarea name="message" class="form-control" rows="5" required></textarea>
        </div>
        <input type="submit" value="Create Announcement" class="btn btn-primary">
    </form>
    <hr>
    <h2>Existing Announcements</h2>
    <table class="table table-bordered mt-3">
        <thead>
            <tr>
                <th>Title</th>
                <th>Message</th>
                <th>Created At</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($announcements as $announcement): ?>
                <tr>
                    <td><?php echo $announcement['title']; ?></td>
                    <td><?php echo $announcement['message']; ?></td>
                    <td><?php echo $announcement['created_at']; ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php include('../includes/footer.php'); ?>