<?php
// commission_settings.php

include('../includes/db.php');
include('../includes/header.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'admin') {
    header("Location: ../public/login.php");
    exit();
}

// Handle commission rate settings update
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $bronze_rate = $_POST['bronze_rate'];
    $silver_rate = $_POST['silver_rate'];
    $gold_rate = $_POST['gold_rate'];

    $stmt = $pdo->prepare("
        UPDATE commission_rates 
        SET rate = CASE
            WHEN tier = 'bronze' THEN :bronze_rate
            WHEN tier = 'silver' THEN :silver_rate
            WHEN tier = 'gold' THEN :gold_rate
        END
    ");
    $stmt->execute([
        'bronze_rate' => $bronze_rate,
        'silver_rate' => $silver_rate,
        'gold_rate' => $gold_rate,
    ]);

    $success = "Commission rates updated successfully.";
}

// Fetch current commission rates
$stmt_rates = $pdo->prepare("SELECT * FROM commission_rates");
$stmt_rates->execute();
$commission_rates = $stmt_rates->fetchAll();

$bronze_rate = $commission_rates[0]['rate'] ?? 0;
$silver_rate = $commission_rates[1]['rate'] ?? 0;
$gold_rate = $commission_rates[2]['rate'] ?? 0;

?>

<div class="container mt-5">
    <h1>Commission Structure Settings</h1>
    <?php if (isset($success)) echo "<div class='alert alert-success'>$success</div>"; ?>
    <form method="POST" action="">
        <div class="form-group">
            <label for="bronze_rate">Bronze Tier Commission Rate (%):</label>
            <input type="number" name="bronze_rate" step="0.1" class="form-control" value="<?php echo $bronze_rate; ?>" required>
        </div>
        <div class="form-group">
            <label for="silver_rate">Silver Tier Commission Rate (%):</label>
            <input type="number" name="silver_rate" step="0.1" class="form-control" value="<?php echo $silver_rate; ?>" required>
        </div>
        <div class="form-group">
            <label for="gold_rate">Gold Tier Commission Rate (%):</label>
            <input type="number" name="gold_rate" step="0.1" class="form-control" value="<?php echo $gold_rate; ?>" required>
        </div>
        <input type="submit" value="Update Rates" class="btn btn-primary mt-3">
    </form>
</div>

<?php include('../includes/footer.php'); ?>