<?php
// custom_reports.php

include('../includes/db.php');
include('../includes/header.php');
include('../includes/navbar.php');
require '../vendor/autoload.php'; // PhpSpreadsheet

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'admin') {
    header("Location: ../public/login.php");
    exit();
}

$filter_user_type = $_GET['user_type'] ?? '';
$filter_start_date = $_GET['start_date'] ?? '';
$filter_end_date = $_GET['end_date'] ?? '';

// Generate report query
$query = "SELECT * FROM users WHERE 1=1";
$params = [];

if ($filter_user_type) {
    $query .= " AND user_type = :user_type";
    $params['user_type'] = $filter_user_type;
}

if ($filter_start_date) {
    $query .= " AND created_at >= :start_date";
    $params['start_date'] = $filter_start_date;
}

if ($filter_end_date) {
    $query .= " AND created_at <= :end_date";
    $params['end_date'] = $filter_end_date;
}

$stmt = $pdo->prepare($query);
$stmt->execute($params);
$users = $stmt->fetchAll();

// Export report
if (isset($_GET['export']) && ($_GET['export'] == 'csv' || $_GET['export'] == 'excel')) {
    if ($_GET['export'] == 'csv') {
        header('Content-Type: text/csv');
        header('Content-Disposition: attachment;filename="user_report.csv"');

        $output = fopen('php://output', 'w');
        fputcsv($output, ['ID', 'Username', 'Email', 'User Type', 'Created At']);

        foreach ($users as $user) {
            fputcsv($output, [$user['id'], $user['username'], $user['email'], $user['user_type'], $user['created_at']]);
        }
        fclose($output);
        exit();
    } elseif ($_GET['export'] == 'excel') {
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();

        // Set header row
        $sheet->setCellValue('A1', 'ID');
        $sheet->setCellValue('B1', 'Username');
        $sheet->setCellValue('C1', 'Email');
        $sheet->setCellValue('D1', 'User Type');
        $sheet->setCellValue('E1', 'Created At');

        // Add data rows
        $rowIndex = 2;
        foreach ($users as $user) {
            $sheet->setCellValue('A' . $rowIndex, $user['id']);
            $sheet->setCellValue('B' . $rowIndex, $user['username']);
            $sheet->setCellValue('C' . $rowIndex, $user['email']);
            $sheet->setCellValue('D' . $rowIndex, $user['user_type']);
            $sheet->setCellValue('E' . $rowIndex, $user['created_at']);
            $rowIndex++;
        }

        // Output Excel file
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="user_report.xlsx"');
        $writer = new Xlsx($spreadsheet);
        $writer->save('php://output');
        exit();
    }
}
?>

<div class="container mt-5">
    <h1>Custom Reports</h1>
    <form method="GET" action="">
        <div class="form-group">
            <label for="user_type">User Type:</label>
            <select name="user_type" class="form-control">
                <option value="">All</option>
                <option value="admin" <?php echo $filter_user_type == 'admin' ? 'selected' : ''; ?>>Admin</option>
                <option value="ib" <?php echo $filter_user_type == 'ib' ? 'selected' : ''; ?>>IB</option>
                <option value="user" <?php echo $filter_user_type == 'user' ? 'selected' : ''; ?>>User</option>
            </select>
        </div>
        <div class="form-group">
            <label for="start_date">Start Date:</label>
            <input type="date" name="start_date" class="form-control" value="<?php echo $filter_start_date; ?>">
        </div>
        <div class="form-group">
            <label for="end_date">End Date:</label>
            <input type="date" name="end_date" class="form-control" value="<?php echo $filter_end_date; ?>">
        </div>
        <input type="submit" value="Filter" class="btn btn-primary">
        <a href="?export=csv" class="btn btn-secondary">Export as CSV</a>
        <a href="?export=excel" class="btn btn-secondary">Export as Excel</a>
    </form>
    <table class="table table-bordered mt-3">
        <thead>
            <tr>
                <th>ID</th>
                <th>Username</th>
                <th>Email</th>
                <th>User Type</th>
                <th>Created At</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($users as $user): ?>
                <tr>
                    <td><?php echo $user['id']; ?></td>
                    <td><?php echo $user['username']; ?></td>
                    <td><?php echo $user['email']; ?></td>
                    <td><?php echo ucfirst($user['user_type']); ?></td>
                    <td><?php echo $user['created_at']; ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php include('../includes/footer.php'); ?>