<?php
// dashboard.php

include('../includes/db.php');
include('../includes/header.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'admin') {
    header("Location: ../public/login.php");
    exit();
}

// Fetch key metrics
$stmt_users = $pdo->prepare("SELECT COUNT(*) as user_count FROM users");
$stmt_users->execute();
$user_count = $stmt_users->fetchColumn();

$stmt_trades = $pdo->prepare("SELECT COUNT(*) as trade_count FROM trades");
$stmt_trades->execute();
$trade_count = $stmt_trades->fetchColumn();

$stmt_pending_kyc = $pdo->prepare("SELECT COUNT(*) as kyc_count FROM users WHERE kyc_status = 'pending'");
$stmt_pending_kyc->execute();
$kyc_count = $stmt_pending_kyc->fetchColumn();

// Fetch IB data for management
$stmt_ibs = $pdo->prepare("SELECT i.*, u.username FROM ibs i LEFT JOIN users u ON i.user_id = u.id ORDER BY i.created_at DESC");
$stmt_ibs->execute();
$ibs = $stmt_ibs->fetchAll();

?>

<div class="container mt-5">
    <h1 class="text-center">Admin Dashboard</h1>

    <!-- Overview Cards -->
    <div class="row mt-4">
        <div class="col-md-3">
            <div class="card text-white bg-primary mb-3">
                <div class="card-body">
                    <h5 class="card-title">Total Users</h5>
                    <p class="card-text"><?php echo $user_count; ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-white bg-success mb-3">
                <div class="card-body">
                    <h5 class="card-title">Total Trades</h5>
                    <p class="card-text"><?php echo $trade_count; ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-white bg-warning mb-3">
                <div class="card-body">
                    <h5 class="card-title">Pending KYC Requests</h5>
                    <p class="card-text"><?php echo $kyc_count; ?></p>
                </div>
            </div>
        </div>
    </div>

    <!-- IB Management Section -->
    <div class="mt-5">
        <h3>IB Management</h3>
        <table class="table table-bordered table-striped mt-3">
            <thead>
                <tr>
                    <th>IB ID</th>
                    <th>Username</th>
                    <th>Level</th>
                    <th>Created At</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($ibs as $ib): ?>
                    <tr>
                        <td><?php echo $ib['id']; ?></td>
                        <td><?php echo $ib['username']; ?></td>
                        <td><?php echo $ib['level']; ?></td>
                        <td><?php echo $ib['created_at']; ?></td>
                        <td>
                            <a href="ib_profile.php?id=<?php echo $ib['id']; ?>" class="btn btn-info btn-sm">View Profile</a>
                            <a href="approve_ib.php?id=<?php echo $ib['id']; ?>" class="btn btn-success btn-sm">Approve</a>
                            <a href="disapprove_ib.php?id=<?php echo $ib['id']; ?>" class="btn btn-danger btn-sm">Disapprove</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include('../includes/footer.php'); ?>