<?php
// login_activity.php

include('../includes/db.php');
include('../includes/header.php');
include('../includes/navbar.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'admin') {
    header("Location: ../public/login.php");
    exit();
}

// Fetch login activities
$stmt = $pdo->prepare("SELECT * FROM login_activity ORDER BY login_time DESC");
$stmt->execute();
$login_activities = $stmt->fetchAll();

?>

<div class="container mt-5">
    <h1>Login Activity</h1>
    <table class="table table-bordered mt-3">
        <thead>
            <tr>
                <th>User ID</th>
                <th>Username</th>
                <th>IP Address</th>
                <th>Status</th>
                <th>Login Time</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($login_activities as $activity): ?>
                <tr>
                    <td><?php echo $activity['user_id']; ?></td>
                    <td><?php echo $activity['username']; ?></td>
                    <td><?php echo $activity['ip_address']; ?></td>
                    <td><?php echo ucfirst($activity['status']); ?></td>
                    <td><?php echo $activity['login_time']; ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php include('../includes/footer.php'); ?>