<?php
// manage_account_deletions.php

include('../includes/db.php');
include('../includes/header.php');
include('../includes/navbar.php');
require '../vendor/autoload.php'; // PHPMailer

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'admin') {
    header("Location: ../public/login.php");
    exit();
}

// Handle approve or reject actions for account deletion requests
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $request_id = $_POST['request_id'];
    $action = $_POST['action'];

    $stmt_request = $pdo->prepare("SELECT * FROM account_deletion_requests WHERE id = :request_id AND status = 'pending'");
    $stmt_request->execute(['request_id' => $request_id]);
    $request = $stmt_request->fetch();

    if ($request) {
        if ($action == 'approve') {
            // Delete user account
            $stmt_delete_user = $pdo->prepare("DELETE FROM users WHERE id = :user_id");
            $stmt_delete_user->execute(['user_id' => $request['user_id']]);

            // Update request status
            $stmt_update_request = $pdo->prepare("UPDATE account_deletion_requests SET status = 'approved', processed_at = NOW() WHERE id = :request_id");
            $stmt_update_request->execute(['request_id' => $request_id]);

            // Notify user via email
            $stmt_user = $pdo->prepare("SELECT email FROM users WHERE id = :user_id");
            $stmt_user->execute(['user_id' => $request['user_id']]);
            $user_email = $stmt_user->fetchColumn();

            $mail = new PHPMailer(true);
            try {
                $mail->setFrom('noreply@forexcrm.com', 'Forex CRM');
                $mail->addAddress($user_email);
                $mail->isHTML(true);
                $mail->Subject = 'Account Deletion Approved';
                $mail->Body = "Your account deletion request has been approved. Your account has been successfully deleted.";

                $mail->send();
            } catch (Exception $e) {
                // Handle email sending error
            }
        } elseif ($action == 'reject') {
            // Update request status
            $stmt_update_request = $pdo->prepare("UPDATE account_deletion_requests SET status = 'rejected', processed_at = NOW() WHERE id = :request_id");
            $stmt_update_request->execute(['request_id' => $request_id]);

            // Notify user via email
            $stmt_user = $pdo->prepare("SELECT email FROM users WHERE id = :user_id");
            $stmt_user->execute(['user_id' => $request['user_id']]);
            $user_email = $stmt_user->fetchColumn();

            $mail = new PHPMailer(true);
            try {
                $mail->setFrom('noreply@forexcrm.com', 'Forex CRM');
                $mail->addAddress($user_email);
                $mail->isHTML(true);
                $mail->Subject = 'Account Deletion Rejected';
                $mail->Body = "Your account deletion request has been rejected. If you have any questions, please contact support.";

                $mail->send();
            } catch (Exception $e) {
                // Handle email sending error
            }
        }
    }
}

// Fetch all pending account deletion requests
$stmt = $pdo->prepare("SELECT * FROM account_deletion_requests WHERE status = 'pending' ORDER BY requested_at DESC");
$stmt->execute();
$deletion_requests = $stmt->fetchAll();

?>

<div class="container mt-5">
    <h1>Manage Account Deletion Requests</h1>
    <table class="table table-bordered mt-3">
        <thead>
            <tr>
                <th>Request ID</th>
                <th>User ID</th>
                <th>Status</th>
                <th>Requested At</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($deletion_requests as $request): ?>
                <tr>
                    <td><?php echo $request['id']; ?></td>
                    <td><?php echo $request['user_id']; ?></td>
                    <td><?php echo ucfirst($request['status']); ?></td>
                    <td><?php echo $request['requested_at']; ?></td>
                    <td>
                        <form method="POST" action="" style="display: inline;">
                            <input type="hidden" name="request_id" value="<?php echo $request['id']; ?>">
                            <button type="submit" name="action" value="approve" class="btn btn-success btn-sm">Approve</button>
                            <button type="submit" name="action" value="reject" class="btn btn-danger btn-sm">Reject</button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php include('../includes/footer.php'); ?>