<link rel="stylesheet" href="../assets/css/bootstrap.min.css">
<script src="../assets/js/jquery.min.js"></script>
<script src="../assets/js/bootstrap.bundle.min.js"></script>


<?php
// admin/manage_ibs.php

session_start();
include('../includes/db.php');

if (!isset($_SESSION['admin_id'])) {
    header("Location: index.php");
    exit();
}

// Fetch all IBs
$stmt = $pdo->prepare("SELECT * FROM ibs");
$stmt->execute();
$ibs = $stmt->fetchAll();

?>

<!DOCTYPE html>
<html>

<head>
    <title>Manage IBs</title>
</head>

<body>
    <h1>Manage IBs</h1>
    <table border="1">
        <thead>
            <tr>
                <th>ID</th>
                <th>User ID</th>
                <th>IB Code</th>
                <th>Level</th>
                <th>Parent IB</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($ibs as $ib): ?>
                <tr>
                    <td><?php echo $ib['id']; ?></td>
                    <td><?php echo $ib['user_id']; ?></td>
                    <td><?php echo $ib['ib_code']; ?></td>
                    <td><?php echo $ib['level']; ?></td>
                    <td><?php echo $ib['parent_ib']; ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</body>

</html>