<?php
// manage_kyc.php

include('../includes/db.php');
include('../includes/header.php');
include('../includes/navbar.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'admin') {
    header("Location: ../public/login.php");
    exit();
}

// Handle approve or reject actions for KYC documents
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $user_id = $_POST['user_id'];
    $action = $_POST['action'];

    if ($action == 'approve') {
        $stmt = $pdo->prepare("UPDATE users SET kyc_status = 'approved' WHERE id = :user_id");
        $stmt->execute(['user_id' => $user_id]);
    } elseif ($action == 'reject') {
        $stmt = $pdo->prepare("UPDATE users SET kyc_status = 'rejected' WHERE id = :user_id");
        $stmt->execute(['user_id' => $user_id]);
    }
}

// Fetch all pending KYC documents
$stmt = $pdo->prepare("SELECT id, username, kyc_document, kyc_status FROM users WHERE kyc_status = 'pending'");
$stmt->execute();
$kyc_requests = $stmt->fetchAll();

?>

<div class="container mt-5">
    <h1>Manage KYC Requests</h1>
    <table class="table table-bordered mt-3">
        <thead>
            <tr>
                <th>User ID</th>
                <th>Username</th>
                <th>Document</th>
                <th>Status</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($kyc_requests as $request): ?>
                <tr>
                    <td><?php echo $request['id']; ?></td>
                    <td><?php echo $request['username']; ?></td>
                    <td><a href="../uploads/kyc_documents/<?php echo $request['kyc_document']; ?>" target="_blank">View Document</a></td>
                    <td><?php echo ucfirst($request['kyc_status']); ?></td>
                    <td>
                        <form method="POST" action="" style="display: inline;">
                            <input type="hidden" name="user_id" value="<?php echo $request['id']; ?>">
                            <button type="submit" name="action" value="approve" class="btn btn-success btn-sm">Approve</button>
                            <button type="submit" name="action" value="reject" class="btn btn-danger btn-sm">Reject</button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php include('../includes/footer.php'); ?>