<?php
// manage_roles.php

include('../includes/db.php');
include('../includes/header.php');
include('../includes/navbar.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'admin') {
    header("Location: ../public/login.php");
    exit();
}

// Fetch all roles
$stmt_roles = $pdo->prepare("SELECT * FROM roles");
$stmt_roles->execute();
$roles = $stmt_roles->fetchAll();

// Handle role permission updates
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $role_id = $_POST['role_id'];
    $permissions = $_POST['permissions'] ?? [];

    // Delete existing permissions
    $stmt_delete = $pdo->prepare("DELETE FROM role_permissions WHERE role_id = :role_id");
    $stmt_delete->execute(['role_id' => $role_id]);

    // Insert new permissions
    foreach ($permissions as $permission) {
        $stmt_insert = $pdo->prepare("INSERT INTO role_permissions (role_id, permission_name) VALUES (:role_id, :permission_name)");
        $stmt_insert->execute(['role_id' => $role_id, 'permission_name' => $permission]);
    }

    $success = "Permissions updated successfully.";
}

// Fetch permissions for each role
$role_permissions = [];
$stmt = $pdo->prepare("SELECT * FROM role_permissions WHERE role_id = :role_id");
foreach ($roles as $role) {
    $stmt->execute(['role_id' => $role['id']]);
    $role_permissions[$role['id']] = $stmt->fetchAll(PDO::FETCH_COLUMN, 1);
}

// Define available permissions
$available_permissions = ['manage_users', 'manage_trades', 'view_reports', 'approve_withdrawals', 'manage_kyc', 'manage_roles'];

?>

<div class="container mt-5">
    <h1>Manage Roles & Permissions</h1>
    <?php if (isset($success)) echo "<div class='alert alert-success'>$success</div>"; ?>
    <?php foreach ($roles as $role): ?>
        <h3><?php echo ucfirst($role['name']); ?> Role</h3>
        <form method="POST" action="">
            <input type="hidden" name="role_id" value="<?php echo $role['id']; ?>">
            <?php foreach ($available_permissions as $permission): ?>
                <div class="form-check">
                    <input type="checkbox" class="form-check-input" name="permissions[]" value="<?php echo $permission; ?>"
                        <?php echo in_array($permission, $role_permissions[$role['id']]) ? 'checked' : ''; ?>>
                    <label class="form-check-label"><?php echo ucfirst(str_replace('_', ' ', $permission)); ?></label>
                </div>
            <?php endforeach; ?>
            <input type="submit" value="Update Permissions" class="btn btn-primary mt-2">
        </form>
        <hr>
    <?php endforeach; ?>
</div>

<?php include('../includes/footer.php'); ?>