<?php
// manage_users.php

include('../includes/db.php');
include('../includes/header.php');
include('../includes/navbar.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'admin') {
    header("Location: ../public/login.php");
    exit();
}

// Handle user suspension or reactivation
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['user_id'])) {
    $user_id = $_POST['user_id'];
    $action = $_POST['action'];

    if ($action == 'suspend') {
        $stmt = $pdo->prepare("UPDATE users SET account_status = 'suspended' WHERE id = :user_id");
        $stmt->execute(['user_id' => $user_id]);
        $success = "User account suspended successfully.";
    } elseif ($action == 'reactivate') {
        $stmt = $pdo->prepare("UPDATE users SET account_status = 'active' WHERE id = :user_id");
        $stmt->execute(['user_id' => $user_id]);
        $success = "User account reactivated successfully.";
    }
}

// Fetch all users or search by username
$query = "SELECT * FROM users";
$params = [];

if (isset($_GET['username']) && $_GET['username'] != '') {
    $query .= " WHERE username LIKE :username";
    $params['username'] = "%" . $_GET['username'] . "%";
}

$stmt = $pdo->prepare($query);
$stmt->execute($params);
$users = $stmt->fetchAll();

?>

<div class="container mt-5">
    <h1>Manage Users</h1>
    <?php if (isset($success)) echo "<div class='alert alert-success'>$success</div>"; ?>
    <form method="GET" action="">
        <div class="form-group">
            <label for="username">Search User by Username:</label>
            <input type="text" name="username" class="form-control">
        </div>
        <input type="submit" value="Search" class="btn btn-secondary">
    </form>
    <hr>
    <h2>User List</h2>
    <table class="table table-bordered mt-3">
        <thead>
            <tr>
                <th>ID</th>
                <th>Username</th>
                <th>Email</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($users as $user): ?>
                <tr>
                    <td><?php echo $user['id']; ?></td>
                    <td><?php echo $user['username']; ?></td>
                    <td><?php echo $user['email']; ?></td>
                    <td><?php echo ucfirst($user['account_status']); ?></td>
                    <td>
                        <form method="POST" action="" style="display: inline;">
                            <input type="hidden" name="user_id" value="<?php echo $user['id']; ?>">
                            <?php if ($user['account_status'] == 'active'): ?>
                                <button type="submit" name="action" value="suspend" class="btn btn-warning btn-sm">Suspend</button>
                            <?php else: ?>
                                <button type="submit" name="action" value="reactivate" class="btn btn-success btn-sm">Reactivate</button>
                            <?php endif; ?>
                        </form>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php include('../includes/footer.php'); ?>