<?php
// manage_withdrawals.php

include('../includes/db.php');
include('../includes/header.php');
include('../includes/navbar.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'admin') {
    header("Location: ../public/login.php");
    exit();
}

// Handle approve or reject actions
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $withdrawal_id = $_POST['withdrawal_id'];
    $action = $_POST['action'];

    if ($action == 'approve') {
        // Approve withdrawal and update user balance
        $stmt = $pdo->prepare("SELECT user_id, amount FROM withdrawals WHERE id = :withdrawal_id AND status = 'pending'");
        $stmt->execute(['withdrawal_id' => $withdrawal_id]);
        $withdrawal = $stmt->fetch();

        if ($withdrawal) {
            $stmt = $pdo->prepare("UPDATE users SET wallet_balance = wallet_balance - :amount WHERE id = :user_id");
            $stmt->execute(['amount' => $withdrawal['amount'], 'user_id' => $withdrawal['user_id']]);

            $stmt = $pdo->prepare("UPDATE withdrawals SET status = 'approved', approval_date = NOW() WHERE id = :withdrawal_id");
            $stmt->execute(['withdrawal_id' => $withdrawal_id]);
        }
    } elseif ($action == 'reject') {
        // Reject withdrawal
        $stmt = $pdo->prepare("UPDATE withdrawals SET status = 'rejected', approval_date = NOW() WHERE id = :withdrawal_id");
        $stmt->execute(['withdrawal_id' => $withdrawal_id]);
    }
}

// Fetch pending withdrawals
$stmt = $pdo->prepare("SELECT * FROM withdrawals WHERE status = 'pending' ORDER BY request_date DESC");
$stmt->execute();
$withdrawals = $stmt->fetchAll();

?>

<div class="container mt-5">
    <h1>Manage Withdrawals</h1>
    <table class="table table-bordered mt-3">
        <thead>
            <tr>
                <th>ID</th>
                <th>User ID</th>
                <th>Amount</th>
                <th>Request Date</th>
                <th>Status</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($withdrawals as $withdrawal): ?>
                <tr>
                    <td><?php echo $withdrawal['id']; ?></td>
                    <td><?php echo $withdrawal['user_id']; ?></td>
                    <td>$<?php echo $withdrawal['amount']; ?></td>
                    <td><?php echo $withdrawal['request_date']; ?></td>
                    <td><?php echo ucfirst($withdrawal['status']); ?></td>
                    <td>
                        <form method="POST" action="" style="display: inline;">
                            <input type="hidden" name="withdrawal_id" value="<?php echo $withdrawal['id']; ?>">
                            <button type="submit" name="action" value="approve" class="btn btn-success btn-sm">Approve</button>
                            <button type="submit" name="action" value="reject" class="btn btn-danger btn-sm">Reject</button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php include('../includes/footer.php'); ?>