<?php
// payout_requests.php

include('../includes/db.php');
include('../includes/header.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'admin') {
    header("Location: ../public/login.php");
    exit();
}

// Fetch pending payout requests
$stmt_payout_requests = $pdo->prepare("SELECT w.*, u.username FROM withdrawal_requests w LEFT JOIN users u ON w.user_id = u.id WHERE w.status = 'pending' ORDER BY w.requested_at DESC");
$stmt_payout_requests->execute();
$payout_requests = $stmt_payout_requests->fetchAll();

// Handle payout approval
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['request_id']) && isset($_POST['action'])) {
    $request_id = $_POST['request_id'];
    $action = $_POST['action'];

    $status = $action === 'approve' ? 'approved' : 'rejected';

    $stmt_update = $pdo->prepare("UPDATE withdrawal_requests SET status = :status, processed_at = NOW() WHERE id = :request_id");
    $stmt_update->execute(['status' => $status, 'request_id' => $request_id]);

    $success = "Payout request has been {$status}.";
}

?>

<div class="container mt-5">
    <h1>IB Payout Requests</h1>
    <?php if (isset($success)) echo "<div class='alert alert-success'>$success</div>"; ?>

    <table class="table table-bordered table-striped mt-3">
        <thead>
            <tr>
                <th>Request ID</th>
                <th>Username</th>
                <th>Amount</th>
                <th>Requested At</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($payout_requests as $request): ?>
                <tr>
                    <td><?php echo $request['id']; ?></td>
                    <td><?php echo $request['username']; ?></td>
                    <td>$<?php echo number_format($request['amount'], 2); ?></td>
                    <td><?php echo $request['requested_at']; ?></td>
                    <td>
                        <form method="POST" action="" style="display: inline-block;">
                            <input type="hidden" name="request_id" value="<?php echo $request['id']; ?>">
                            <button type="submit" name="action" value="approve" class="btn btn-success btn-sm">Approve</button>
                            <button type="submit" name="action" value="reject" class="btn btn-danger btn-sm">Reject</button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php include('../includes/footer.php'); ?>