<?php
// schedule_maintenance.php

include('../includes/db.php');
include('../includes/header.php');
include('../includes/navbar.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'admin') {
    header("Location: ../public/login.php");
    exit();
}

// Handle maintenance scheduling
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $maintenance_title = $_POST['maintenance_title'];
    $maintenance_date = $_POST['maintenance_date'];
    $maintenance_message = $_POST['maintenance_message'];

    $stmt = $pdo->prepare("INSERT INTO maintenance_schedule (title, maintenance_date, message, created_at) VALUES (:title, :maintenance_date, :message, NOW())");
    $stmt->execute([
        'title' => $maintenance_title,
        'maintenance_date' => $maintenance_date,
        'message' => $maintenance_message,
    ]);

    $success = "Maintenance alert scheduled successfully.";
}

?>

<div class="container mt-5">
    <h1>Schedule Maintenance</h1>
    <?php if (isset($success)) echo "<div class='alert alert-success'>$success</div>"; ?>
    <form method="POST" action="">
        <div class="form-group">
            <label for="maintenance_title">Title:</label>
            <input type="text" name="maintenance_title" class="form-control" required>
        </div>
        <div class="form-group">
            <label for="maintenance_date">Maintenance Date:</label>
            <input type="datetime-local" name="maintenance_date" class="form-control" required>
        </div>
        <div class="form-group">
            <label for="maintenance_message">Message:</label>
            <textarea name="maintenance_message" class="form-control" rows="3" required></textarea>
        </div>
        <input type="submit" value="Schedule Maintenance" class="btn btn-primary">
    </form>
</div>

<?php include('../includes/footer.php'); ?>