<?php
// system_health.php

include('../includes/db.php');
include('../includes/header.php');
include('../includes/navbar.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'admin') {
    header("Location: ../public/login.php");
    exit();
}

// Fetch system health data
$database_status = $pdo->query("SELECT 1")->fetch() ? 'Online' : 'Offline';
$disk_usage = disk_free_space("/") / 1024 / 1024 / 1024; // in GB
$total_memory = shell_exec("free -m | awk 'NR==2{printf \"%s\", $2}'"); // Total memory in MB
$used_memory = shell_exec("free -m | awk 'NR==2{printf \"%s\", $3}'"); // Used memory in MB

?>

<div class="container mt-5">
    <h1>System Health Check</h1>
    <div class="row mt-4">
        <div class="col-md-4">
            <div class="card text-white bg-primary mb-3">
                <div class="card-body">
                    <h5 class="card-title">Database Status</h5>
                    <p class="card-text"><?php echo $database_status; ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card text-white bg-success mb-3">
                <div class="card-body">
                    <h5 class="card-title">Free Disk Space</h5>
                    <p class="card-text"><?php echo number_format($disk_usage, 2); ?> GB</p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card text-white bg-warning mb-3">
                <div class="card-body">
                    <h5 class="card-title">Memory Usage</h5>
                    <p class="card-text">Used: <?php echo $used_memory; ?> MB / Total: <?php echo $total_memory; ?> MB</p>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include('../includes/footer.php'); ?>