<?php
// task_assignments.php

include('../includes/db.php');
include('../includes/header.php');
include('../includes/navbar.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'admin') {
    header("Location: ../public/login.php");
    exit();
}

// Handle task creation
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $assignee_id = $_POST['assignee_id'];
    $task_title = $_POST['task_title'];
    $task_description = $_POST['task_description'];

    $stmt = $pdo->prepare("INSERT INTO tasks (assignee_id, task_title, task_description, created_at, status) VALUES (:assignee_id, :task_title, :task_description, NOW(), 'pending')");
    $stmt->execute([
        'assignee_id' => $assignee_id,
        'task_title' => $task_title,
        'task_description' => $task_description,
    ]);

    $success = "Task assigned successfully.";
}

// Fetch all users for task assignment
$stmt_users = $pdo->prepare("SELECT id, username FROM users");
$stmt_users->execute();
$users = $stmt_users->fetchAll();

?>

<div class="container mt-5">
    <h1>Task Assignment</h1>
    <?php if (isset($success)) echo "<div class='alert alert-success'>$success</div>"; ?>
    <form method="POST" action="">
        <div class="form-group">
            <label for="assignee_id">Assign To:</label>
            <select name="assignee_id" class="form-control" required>
                <?php foreach ($users as $user): ?>
                    <option value="<?php echo $user['id']; ?>"><?php echo $user['username']; ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group">
            <label for="task_title">Task Title:</label>
            <input type="text" name="task_title" class="form-control" required>
        </div>
        <div class="form-group">
            <label for="task_description">Task Description:</label>
            <textarea name="task_description" class="form-control" rows="4" required></textarea>
        </div>
        <input type="submit" value="Assign Task" class="btn btn-primary">
    </form>
</div>

<?php include('../includes/footer.php'); ?>