<?php
// trade_analytics.php

include('../includes/db.php');
include('../includes/header.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'admin') {
    header("Location: ../public/login.php");
    exit();
}

// Fetch trade metrics
$stmt_trades = $pdo->prepare("SELECT COUNT(*) as trade_count, trade_type FROM trades GROUP BY trade_type");
$stmt_trades->execute();
$trade_data = $stmt_trades->fetchAll(PDO::FETCH_ASSOC);

$buy_count = 0;
$sell_count = 0;

foreach ($trade_data as $data) {
    if ($data['trade_type'] == 'buy') {
        $buy_count = $data['trade_count'];
    } elseif ($data['trade_type'] == 'sell') {
        $sell_count = $data['trade_count'];
    }
}

?>

<div class="container mt-5">
    <h1>Trade Analytics</h1>
    <div class="row mt-5">
        <div class="col-md-12">
            <h3>Trade Overview</h3>
            <canvas id="tradeChart" width="400" height="150"></canvas>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    var ctx = document.getElementById('tradeChart').getContext('2d');
    var tradeChart = new Chart(ctx, {
        type: 'doughnut',
        data: {
            labels: ['Buy Trades', 'Sell Trades'],
            datasets: [{
                data: [<?php echo $buy_count; ?>, <?php echo $sell_count; ?>],
                backgroundColor: ['#36a2eb', '#ff6384'],
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top',
                }
            }
        }
    });
</script>

<?php include('../includes/footer.php'); ?>