<?php
// admin/trade_report.php

include('../includes/db.php');
include('../includes/header.php');
include('../includes/navbar.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'admin') {
    header("Location: ../public/login.php");
    exit();
}

$start_date = $_GET['start_date'] ?? null;
$end_date = $_GET['end_date'] ?? null;
$currency_pair = $_GET['currency_pair'] ?? null;
$user_id = $_GET['user_id'] ?? null;
$trade_type = $_GET['trade_type'] ?? null;

$query = "SELECT * FROM trades WHERE 1=1";
$params = [];

if ($start_date) {
    $query .= " AND trade_date >= :start_date";
    $params['start_date'] = $start_date;
}
if ($end_date) {
    $query .= " AND trade_date <= :end_date";
    $params['end_date'] = $end_date;
}
if ($currency_pair) {
    $query .= " AND currency_pair = :currency_pair";
    $params['currency_pair'] = $currency_pair;
}
if ($user_id) {
    $query .= " AND user_id = :user_id";
    $params['user_id'] = $user_id;
}
if ($trade_type) {
    $query .= " AND trade_type = :trade_type";
    $params['trade_type'] = $trade_type;
}

$stmt = $pdo->prepare($query);
$stmt->execute($params);
$trades = $stmt->fetchAll();
?>

<div class="container mt-5">
    <h2>Trade Report</h2>
    <form method="GET" action="">
        <div class="form-group">
            <label for="start_date">Start Date:</label>
            <input type="date" name="start_date" class="form-control" value="<?php echo $start_date; ?>">
        </div>
        <div class="form-group">
            <label for="end_date">End Date:</label>
            <input type="date" name="end_date" class="form-control" value="<?php echo $end_date; ?>">
        </div>
        <div class="form-group">
            <label for="currency_pair">Currency Pair:</label>
            <input type="text" name="currency_pair" class="form-control" value="<?php echo $currency_pair; ?>">
        </div>
        <div class="form-group">
            <label for="user_id">User ID:</label>
            <input type="text" name="user_id" class="form-control" value="<?php echo $user_id; ?>">
        </div>
        <div class="form-group">
            <label for="trade_type">Trade Type:</label>
            <select name="trade_type" class="form-control">
                <option value="">All</option>
                <option value="buy" <?php echo ($trade_type == 'buy') ? 'selected' : ''; ?>>Buy</option>
                <option value="sell" <?php echo ($trade_type == 'sell') ? 'selected' : ''; ?>>Sell</option>
            </select>
        </div>
        <input type="submit" value="Filter" class="btn btn-primary">
    </form>

    <table class="table table-bordered mt-3">
        <thead>
            <tr>
                <th>ID</th>
                <th>User ID</th>
                <th>Trade Type</th>
                <th>Currency Pair</th>
                <th>Amount</th>
                <th>Profit/Loss</th>
                <th>Trade Date</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($trades as $trade): ?>
                <tr>
                    <td><?php echo $trade['id']; ?></td>
                    <td><?php echo $trade['user_id']; ?></td>
                    <td><?php echo $trade['trade_type']; ?></td>
                    <td><?php echo $trade['currency_pair']; ?></td>
                    <td>$<?php echo $trade['amount']; ?></td>
                    <td>$<?php echo $trade['profit_loss']; ?></td>
                    <td><?php echo $trade['trade_date']; ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php include('../includes/footer.php'); ?>