<?php
// user_analytics.php

include('../includes/db.php');
include('../includes/header.php');
include('../includes/navbar.php');
require '../vendor/autoload.php'; // PhpSpreadsheet

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'admin') {
    header("Location: ../public/login.php");
    exit();
}

// Fetch user metrics
$stmt_active_users = $pdo->prepare("SELECT COUNT(*) as active_count FROM users WHERE account_status = 'active'");
$stmt_active_users->execute();
$active_count = $stmt_active_users->fetchColumn();

$stmt_suspended_users = $pdo->prepare("SELECT COUNT(*) as suspended_count FROM users WHERE account_status = 'suspended'");
$stmt_suspended_users->execute();
$suspended_count = $stmt_suspended_users->fetchColumn();

$stmt_kyc_pending = $pdo->prepare("SELECT COUNT(*) as kyc_pending FROM users WHERE kyc_status = 'pending'");
$stmt_kyc_pending->execute();
$kyc_pending = $stmt_kyc_pending->fetchColumn();

// Export user data
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['export'])) {
    $stmt = $pdo->prepare("SELECT * FROM users");
    $stmt->execute();
    $users = $stmt->fetchAll();

    // Create an Excel file with user data
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();

    // Set user data header
    $sheet->setCellValue('A1', 'ID');
    $sheet->setCellValue('B1', 'Username');
    $sheet->setCellValue('C1', 'Email');
    $sheet->setCellValue('D1', 'Account Status');
    $sheet->setCellValue('E1', 'KYC Status');
    $sheet->setCellValue('F1', 'Created At');

    // Add user data
    $rowIndex = 2;
    foreach ($users as $user) {
        $sheet->setCellValue('A' . $rowIndex, $user['id']);
        $sheet->setCellValue('B' . $rowIndex, $user['username']);
        $sheet->setCellValue('C' . $rowIndex, $user['email']);
        $sheet->setCellValue('D' . $rowIndex, $user['account_status']);
        $sheet->setCellValue('E' . $rowIndex, $user['kyc_status']);
        $sheet->setCellValue('F' . $rowIndex, $user['created_at']);
        $rowIndex++;
    }

    // Output Excel file
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="user_data.xlsx"');
    $writer = new Xlsx($spreadsheet);
    $writer->save('php://output');
    exit();
}

?>

<div class="container mt-5">
    <h1>User Analytics</h1>
    <div class="row mt-4">
        <div class="col-md-4">
            <div class="card text-white bg-primary mb-3">
                <div class="card-body">
                    <h5 class="card-title">Active Users</h5>
                    <p class="card-text"><?php echo $active_count; ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card text-white bg-warning mb-3">
                <div class="card-body">
                    <h5 class="card-title">Suspended Users</h5>
                    <p class="card-text"><?php echo $suspended_count; ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card text-white bg-danger mb-3">
                <div class="card-body">
                    <h5 class="card-title">Pending KYC Requests</h5>
                    <p class="card-text"><?php echo $kyc_pending; ?></p>
                </div>
            </div>
        </div>
    </div>

    <!-- Export User Data -->
    <div class="mt-5">
        <h2>Export User Data</h2>
        <form method="POST" action="">
            <input type="hidden" name="export" value="1">
            <input type="submit" value="Export Data as Excel" class="btn btn-primary">
        </form>
    </div>
</div>

<?php include('../includes/footer.php'); ?>