<?php
// wallet_history.php (admin version)

include('../includes/db.php');
include('../includes/header.php');
include('../includes/navbar.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'admin') {
    header("Location: ../public/login.php");
    exit();
}

// Fetch all deposit and withdrawal history
$stmt = $pdo->prepare("SELECT * FROM transactions ORDER BY transaction_date DESC");
$stmt->execute();
$transactions = $stmt->fetchAll();

?>

<div class="container mt-5">
    <h1>All Wallet Transactions</h1>
    <table class="table table-bordered mt-3">
        <thead>
            <tr>
                <th>ID</th>
                <th>User ID</th>
                <th>Transaction Type</th>
                <th>Amount</th>
                <th>Transaction Date</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($transactions as $transaction): ?>
                <tr>
                    <td><?php echo $transaction['id']; ?></td>
                    <td><?php echo $transaction['user_id']; ?></td>
                    <td><?php echo ucfirst($transaction['transaction_type']); ?></td>
                    <td>$<?php echo $transaction['amount']; ?></td>
                    <td><?php echo $transaction['transaction_date']; ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php include('../includes/footer.php'); ?>