<?php
// commission_history.php

include('../includes/db.php');
include('../includes/header.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'ib') {
    header("Location: ../public/login.php");
    exit();
}

$user_id = $_SESSION['user_id'];

// Fetch IB commission payout history
$stmt_payouts = $pdo->prepare("SELECT * FROM withdrawal_requests WHERE user_id = :user_id ORDER BY requested_at DESC");
$stmt_payouts->execute(['user_id' => $user_id]);
$payouts = $stmt_payouts->fetchAll();

?>

<div class="container mt-5">
    <h1>Commission Payout History</h1>
    <table class="table table-bordered table-striped mt-3">
        <thead>
            <tr>
                <th>ID</th>
                <th>Amount</th>
                <th>Status</th>
                <th>Requested At</th>
                <th>Processed At</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($payouts as $payout): ?>
                <tr>
                    <td><?php echo $payout['id']; ?></td>
                    <td>$<?php echo number_format($payout['amount'], 2); ?></td>
                    <td><?php echo ucfirst($payout['status']); ?></td>
                    <td><?php echo $payout['requested_at']; ?></td>
                    <td><?php echo $payout['processed_at'] ? $payout['processed_at'] : 'Pending'; ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php include('../includes/footer.php'); ?>