<link rel="stylesheet" href="../assets/css/bootstrap.min.css">
<script src="../assets/js/jquery.min.js"></script>
<script src="../assets/js/bootstrap.bundle.min.js"></script>


<?php
// ib/commissions.php

session_start();
include('../includes/db.php');

if (!isset($_SESSION['ib_id'])) {
    header("Location: ../public/login.php");
    exit();
}

// Fetch commissions for IB
$stmt = $pdo->prepare("SELECT * FROM commissions WHERE ib_id = :ib_id");
$stmt->execute(['ib_id' => $_SESSION['ib_id']]);
$commissions = $stmt->fetchAll();

?>

<!DOCTYPE html>
<html>

<head>
    <title>IB Commissions</title>
</head>

<body>
    <h1>Your Commissions</h1>
    <table border="1">
        <thead>
            <tr>
                <th>ID</th>
                <th>Trade ID</th>
                <th>Commission Rate (%)</th>
                <th>Commission Amount</th>
                <th>Date</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($commissions as $commission): ?>
                <tr>
                    <td><?php echo $commission['id']; ?></td>
                    <td><?php echo $commission['trade_id']; ?></td>
                    <td><?php echo $commission['commission_rate']; ?></td>
                    <td><?php echo $commission['commission_amount']; ?></td>
                    <td><?php echo $commission['created_at']; ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</body>

</html>