<?php
// ib_dashboard.php

include('../includes/db.php');
include('../includes/header.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'ib') {
    header("Location: ../public/login.php");
    exit();
}

$user_id = $_SESSION['user_id'];

// Fetch IB data
$stmt_ib = $pdo->prepare("SELECT * FROM ibs WHERE user_id = :user_id");
$stmt_ib->execute(['user_id' => $user_id]);
$ib = $stmt_ib->fetch();

// Fetch referred users count
$stmt_referrals = $pdo->prepare("SELECT COUNT(*) as referral_count FROM users WHERE referred_by = :ib_code");
$stmt_referrals->execute(['ib_code' => $ib['ib_code']]);
$referral_count = $stmt_referrals->fetchColumn();

// Fetch commission earned
$stmt_commissions = $pdo->prepare("SELECT SUM(commission_amount) as total_commission FROM commissions WHERE ib_id = :ib_id");
$stmt_commissions->execute(['ib_id' => $ib['id']]);
total_commission = $stmt_commissions->fetchColumn();

// Fetch recent commissions
$stmt_recent_commissions = $pdo->prepare("SELECT * FROM commissions WHERE ib_id = :ib_id ORDER BY created_at DESC LIMIT 5");
$stmt_recent_commissions->execute(['ib_id' => $ib['id']]);
$recent_commissions = $stmt_recent_commissions->fetchAll();
?>

<div class="container mt-5">
    <h1 class="text-center">IB Dashboard</h1>
    <div class="row mt-4">
        <!-- Referred Users Card -->
        <div class="col-md-4">
            <div class="card text-white bg-primary mb-3">
                <div class="card-body">
                    <h5 class="card-title">Referred Users</h5>
                    <p class="card-text"><?php echo $referral_count; ?></p>
                </div>
            </div>
        </div>
        <!-- Total Commission Earned Card -->
        <div class="col-md-4">
            <div class="card text-white bg-success mb-3">
                <div class="card-body">
                    <h5 class="card-title">Total Commission Earned</h5>
                    <p class="card-text">$<?php echo number_format($total_commission, 2); ?></p>
                </div>
            </div>
        </div>
        <!-- Commission Withdrawal Card -->
        <div class="col-md-4">
            <div class="card text-white bg-warning mb-3">
                <div class="card-body">
                    <h5 class="card-title">Withdrawable Commission</h5>
                    <p class="card-text">$<?php echo number_format($total_commission, 2); ?></p>
                    <a href="withdraw_commission.php" class="btn btn-light mt-2">Request Withdrawal</a>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Commissions Table -->
    <div class="mt-5">
        <h3>Recent Commissions Earned</h3>
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>Trade ID</th>
                    <th>Commission Rate</th>
                    <th>Commission Amount</th>
                    <th>Created At</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($recent_commissions as $commission): ?>
                    <tr>
                        <td><?php echo $commission['trade_id']; ?></td>
                        <td><?php echo $commission['commission_rate']; ?>%</td>
                        <td>$<?php echo $commission['commission_amount']; ?></td>
                        <td><?php echo $commission['created_at']; ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include('../includes/footer.php'); ?>