<?php
// earnings_overview.php

include('../includes/db.php');
include('../includes/header.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'ib') {
    header("Location: ../public/login.php");
    exit();
}

$user_id = $_SESSION['user_id'];

// Fetch IB code
$stmt_ib = $pdo->prepare("SELECT * FROM ibs WHERE user_id = :user_id");
$stmt_ib->execute(['user_id' => $user_id]);
$ib = $stmt_ib->fetch();
$ib_code = $ib['ib_code'];

// Fetch direct referral earnings
$stmt_direct_earnings = $pdo->prepare("
    SELECT SUM(c.commission_amount) as total_earnings 
    FROM commissions c
    JOIN users u ON u.id = c.user_id
    WHERE u.referred_by = :ib_code
");
$stmt_direct_earnings->execute(['ib_code' => $ib_code]);
$direct_earnings = $stmt_direct_earnings->fetchColumn() ?? 0;

// Fetch indirect referral earnings
$stmt_indirect_earnings = $pdo->prepare("
    SELECT SUM(c.commission_amount) as total_earnings 
    FROM commissions c
    JOIN ibs i ON i.user_id = c.user_id
    WHERE i.parent_ib = :ib_id
");
$stmt_indirect_earnings->execute(['ib_id' => $ib['id']]);
$indirect_earnings = $stmt_indirect_earnings->fetchColumn() ?? 0;

?>

<div class="container mt-5">
    <h1>Multi-Level Earnings Overview</h1>
    <div class="row mt-4">
        <div class="col-md-6">
            <div class="card text-white bg-success mb-3">
                <div class="card-body">
                    <h5 class="card-title">Direct Referral Earnings</h5>
                    <p class="card-text">$<?php echo number_format($direct_earnings, 2); ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card text-white bg-primary mb-3">
                <div class="card-body">
                    <h5 class="card-title">Indirect Referral Earnings</h5>
                    <p class="card-text">$<?php echo number_format($indirect_earnings, 2); ?></p>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include('../includes/footer.php'); ?>