<?php
include('../includes/db.php');
include('../includes/header.php');
include('../includes/navbar.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'ib') {
    header("Location: ../public/login.php");
    exit();
}

$user_id = $_SESSION['user_id'];

// Fetch IB details and commissions
$stmt_ib = $pdo->prepare("SELECT * FROM ibs WHERE user_id = :user_id");
$stmt_ib->execute(['user_id' => $user_id]);
$ib = $stmt_ib->fetch();

$stmt_commission = $pdo->prepare("SELECT SUM(commission_amount) AS total_commission FROM commissions WHERE ib_id = :ib_id");
$stmt_commission->execute(['ib_id' => $ib['id']]);
$total_commission = $stmt_commission->fetchColumn();

// Fetch referred users
$stmt_referred_users = $pdo->prepare("SELECT * FROM users WHERE referred_by = :ib_code");
$stmt_referred_users->execute(['ib_code' => $ib['ib_code']]);
$referred_users = $stmt_referred_users->fetchAll();

?>

<div class="container mt-5">
    <h1>IB Dashboard</h1>
    <div class="row mt-4">
        <div class="col-md-4">
            <div class="card text-white bg-primary mb-3">
                <div class="card-body">
                    <h5 class="card-title">Total Commissions Earned</h5>
                    <p class="card-text">$<?php echo $total_commission ?: '0.00'; ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card text-white bg-success mb-3">
                <div class="card-body">
                    <h5 class="card-title">Total Referred Users</h5>
                    <p class="card-text"><?php echo count($referred_users); ?></p>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include('../includes/footer.php'); ?>