<?php
// leaderboard.php

include('../includes/db.php');
include('../includes/header.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'ib') {
    header("Location: ../public/login.php");
    exit();
}

// Fetch IB leaderboard data
$stmt_leaderboard = $pdo->prepare("
    SELECT i.user_id, u.username, COUNT(r.id) as referral_count, SUM(c.commission_amount) as total_commission
    FROM ibs i
    LEFT JOIN users u ON i.user_id = u.id
    LEFT JOIN users r ON r.referred_by = i.ib_code
    LEFT JOIN commissions c ON c.ib_id = i.id
    GROUP BY i.user_id
    ORDER BY total_commission DESC, referral_count DESC
    LIMIT 10
");
$stmt_leaderboard->execute();
$leaderboard = $stmt_leaderboard->fetchAll();

?>

<div class="container mt-5">
    <h1>IB Leaderboard</h1>
    <p>Check how you rank among other Introducing Brokers based on referrals and commissions earned.</p>
    <table class="table table-bordered table-striped mt-3">
        <thead>
            <tr>
                <th>Rank</th>
                <th>IB Username</th>
                <th>Referrals</th>
                <th>Total Commission Earned</th>
            </tr>
        </thead>
        <tbody>
            <?php $rank = 1; ?>
            <?php foreach ($leaderboard as $ib): ?>
                <tr>
                    <td><?php echo $rank++; ?></td>
                    <td><?php echo $ib['username']; ?></td>
                    <td><?php echo $ib['referral_count']; ?></td>
                    <td>$<?php echo number_format($ib['total_commission'], 2); ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php include('../includes/footer.php'); ?>