<?php
// notifications.php

include('../includes/db.php');
include('../includes/header.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'ib') {
    header("Location: ../public/login.php");
    exit();
}

$user_id = $_SESSION['user_id'];

// Fetch notifications
$stmt_notifications = $pdo->prepare("SELECT * FROM notifications WHERE user_id = :user_id ORDER BY created_at DESC");
$stmt_notifications->execute(['user_id' => $user_id]);
$notifications = $stmt_notifications->fetchAll();

?>

<div class="container mt-5">
    <h1>Notifications Dashboard</h1>
    <ul class="list-group mt-3">
        <?php foreach ($notifications as $notification): ?>
            <li class="list-group-item d-flex justify-content-between align-items-center">
                <div>
                    <strong><?php echo $notification['title']; ?>:</strong> <?php echo $notification['message']; ?>
                    <small class="text-muted d-block"><?php echo $notification['created_at']; ?></small>
                </div>
                <button class="btn btn-sm btn-secondary">Mark as Read</button>
            </li>
        <?php endforeach; ?>
    </ul>
</div>

<?php include('../includes/footer.php'); ?>