<?php
// referral_profile.php

include('../includes/db.php');
include('../includes/header.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'ib') {
    header("Location: ../public/login.php");
    exit();
}

$referral_id = $_GET['id'];

// Fetch referral details
$stmt_referral = $pdo->prepare("SELECT * FROM users WHERE id = :referral_id");
$stmt_referral->execute(['referral_id' => $referral_id]);
$referral = $stmt_referral->fetch();

// Fetch referral trades
$stmt_trades = $pdo->prepare("SELECT * FROM trades WHERE user_id = :referral_id ORDER BY trade_date DESC");
$stmt_trades->execute(['referral_id' => $referral_id]);
$trades = $stmt_trades->fetchAll();

?>

<div class="container mt-5">
    <h1>Referral Profile - <?php echo $referral['username']; ?></h1>

    <div class="card mt-3">
        <div class="card-body">
            <h5 class="card-title">Referral Information</h5>
            <p><strong>Email:</strong> <?php echo $referral['email']; ?></p>
            <p><strong>Signup Date:</strong> <?php echo $referral['created_at']; ?></p>
        </div>
    </div>

    <div class="mt-5">
        <h3>Recent Trades</h3>
        <table class="table table-bordered table-striped mt-3">
            <thead>
                <tr>
                    <th>Trade Type</th>
                    <th>Currency Pair</th>
                    <th>Amount</th>
                    <th>Profit/Loss</th>
                    <th>Trade Date</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($trades as $trade): ?>
                    <tr>
                        <td><?php echo ucfirst($trade['trade_type']); ?></td>
                        <td><?php echo $trade['currency_pair']; ?></td>
                        <td>$<?php echo $trade['amount']; ?></td>
                        <td>$<?php echo $trade['profit_loss']; ?></td>
                        <td><?php echo $trade['trade_date']; ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include('../includes/footer.php'); ?>