<?php
// referral_tree.php

include('../includes/db.php');
include('../includes/header.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'ib') {
    header("Location: ../public/login.php");
    exit();
}

$user_id = $_SESSION['user_id'];

// Fetch IB information
$stmt_ib = $pdo->prepare("SELECT * FROM ibs WHERE user_id = :user_id");
$stmt_ib->execute(['user_id' => $user_id]);
$ib = $stmt_ib->fetch();

// Fetch all referrals recursively
function fetchReferrals($pdo, $ib_code)
{
    $stmt = $pdo->prepare("SELECT * FROM users WHERE referred_by = :ib_code");
    $stmt->execute(['ib_code' => $ib_code]);
    $referrals = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($referrals as &$referral) {
        $referral['children'] = fetchReferrals($pdo, $referral['referral_code']);
    }
    return $referrals;
}

$referral_tree = fetchReferrals($pdo, $ib['ib_code']);
?>

<div class="container mt-5">
    <h1>Referral Tree</h1>
    <div id="tree"></div>
</div>

<script src="https://d3js.org/d3.v5.min.js"></script>
<script>
    const treeData = <?php echo json_encode($referral_tree); ?>;

    // Set the dimensions and margins of the diagram
    const margin = {
            top: 20,
            right: 90,
            bottom: 30,
            left: 90
        },
        width = 960 - margin.left - margin.right,
        height = 500 - margin.top - margin.bottom;

    // Appends an svg object to the body of the page
    const svg = d3.select("#tree").append("svg")
        .attr("width", width + margin.left + margin.right)
        .attr("height", height + margin.top + margin.bottom)
        .append("g")
        .attr("transform", `translate(${margin.left},${margin.top})`);

    const root = d3.hierarchy(treeData[0]);

    const treeLayout = d3.tree().size([height, width]);
    treeLayout(root);

    // Links
    svg.selectAll('path')
        .data(root.links())
        .enter()
        .append('path')
        .attr('d', d3.linkHorizontal()
            .x(d => d.y)
            .y(d => d.x)
        )
        .attr('fill', 'none')
        .attr('stroke', '#ccc');

    // Nodes
    svg.selectAll('circle')
        .data(root.descendants())
        .enter()
        .append('circle')
        .attr('cx', d => d.y)
        .attr('cy', d => d.x)
        .attr('r', 4)
        .attr('fill', '#69b3a2');

    svg.selectAll('text')
        .data(root.descendants())
        .enter()
        .append('text')
        .attr('x', d => d.y + 10)
        .attr('y', d => d.x)
        .text(d => d.data.username);
</script>

<?php include('../includes/footer.php'); ?>