<?php
// referrals.php

include('../includes/db.php');
include('../includes/header.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'ib') {
    header("Location: ../public/login.php");
    exit();
}

$user_id = $_SESSION['user_id'];

// Fetch IB code
$stmt_ib = $pdo->prepare("SELECT ib_code FROM ibs WHERE user_id = :user_id");
$stmt_ib->execute(['user_id' => $user_id]);
$ib_code = $stmt_ib->fetchColumn();

// Fetch direct referrals
$stmt_direct_referrals = $pdo->prepare("SELECT * FROM users WHERE referred_by = :ib_code");
$stmt_direct_referrals->execute(['ib_code' => $ib_code]);
$direct_referrals = $stmt_direct_referrals->fetchAll();

// Handle adding a note to a referral
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['referral_id']) && isset($_POST['note'])) {
    $referral_id = $_POST['referral_id'];
    $note = $_POST['note'];

    $stmt_note = $pdo->prepare("UPDATE users SET referral_note = :note WHERE id = :referral_id AND referred_by = :ib_code");
    $stmt_note->execute(['note' => $note, 'referral_id' => $referral_id, 'ib_code' => $ib_code]);

    $success = "Referral note updated successfully.";
}

?>

<div class="container mt-5">
    <h1>Manage Referrals</h1>
    <?php if (isset($success)) echo "<div class='alert alert-success'>$success</div>"; ?>

    <!-- Direct Referrals Table -->
    <div class="mt-5">
        <h3>Direct Referrals</h3>
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Username</th>
                    <th>Email</th>
                    <th>Signup Date</th>
                    <th>Note</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($direct_referrals as $referral): ?>
                    <tr>
                        <td><?php echo $referral['id']; ?></td>
                        <td><?php echo $referral['username']; ?></td>
                        <td><?php echo $referral['email']; ?></td>
                        <td><?php echo $referral['created_at']; ?></td>
                        <td><?php echo $referral['referral_note']; ?></td>
                        <td>
                            <form method="POST" action="" style="display: inline-block;">
                                <input type="hidden" name="referral_id" value="<?php echo $referral['id']; ?>">
                                <input type="text" name="note" placeholder="Add note" value="<?php echo $referral['referral_note']; ?>" class="form-control form-control-sm mb-2">
                                <input type="submit" value="Update Note" class="btn btn-primary btn-sm">
                            </form>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include('../includes/footer.php'); ?>