<?php
// withdraw_commission.php

include('../includes/db.php');
include('../includes/header.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'ib') {
    header("Location: ../public/login.php");
    exit();
}

$user_id = $_SESSION['user_id'];

// Fetch IB commission balance
$stmt_commission = $pdo->prepare("SELECT SUM(commission_amount) as total_commission FROM commissions WHERE ib_id = (SELECT id FROM ibs WHERE user_id = :user_id)");
$stmt_commission->execute(['user_id' => $user_id]);
$total_commission = $stmt_commission->fetchColumn();

// Handle withdrawal request
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['amount'])) {
    $amount = $_POST['amount'];

    if ($amount > $total_commission) {
        $error = "You cannot withdraw more than your total earned commission.";
    } elseif ($amount <= 0) {
        $error = "Please enter a valid amount.";
    } else {
        // Record withdrawal request
        $stmt = $pdo->prepare("INSERT INTO withdrawal_requests (user_id, amount, status, requested_at) VALUES (:user_id, :amount, 'pending', NOW())");
        $stmt->execute(['user_id' => $user_id, 'amount' => $amount]);

        $success = "Your withdrawal request has been submitted successfully.";
    }
}

?>

<div class="container mt-5">
    <h1>Request Commission Withdrawal</h1>
    <?php if (isset($success)) echo "<div class='alert alert-success'>$success</div>"; ?>
    <?php if (isset($error)) echo "<div class='alert alert-danger'>$error</div>"; ?>

    <form method="POST" action="">
        <div class="form-group">
            <label for="amount">Amount to Withdraw:</label>
            <input type="number" name="amount" step="0.01" class="form-control" required>
        </div>
        <input type="submit" value="Request Withdrawal" class="btn btn-primary mt-3">
    </form>
</div>

<?php include('../includes/footer.php'); ?>