<?php
// functions.php

function createNotification($pdo, $user_id, $message)
{
    $stmt = $pdo->prepare("INSERT INTO notifications (user_id, message, created_at) VALUES (:user_id, :message, NOW())");
    $stmt->execute(['user_id' => $user_id, 'message' => $message]);
}

function getUnreadNotifications($pdo, $user_id)
{
    $stmt = $pdo->prepare("SELECT * FROM notifications WHERE user_id = :user_id AND is_read = FALSE");
    $stmt->execute(['user_id' => $user_id]);
    return $stmt->fetchAll();
}

function markNotificationsAsRead($pdo, $user_id)
{
    $stmt = $pdo->prepare("UPDATE notifications SET is_read = TRUE WHERE user_id = :user_id AND is_read = FALSE");
    $stmt->execute(['user_id' => $user_id]);
}

// New Function: Send Email Notification
function sendEmailNotification($to, $subject, $message)
{
    // Headers
    $headers = "From: noreply@forexcrm.com\r\n";
    $headers .= "Reply-To: noreply@forexcrm.com\r\n";
    $headers .= "Content-type: text/html\r\n";

    // Send the email
    if (mail($to, $subject, $message, $headers)) {
        return true;
    } else {
        return false;
    }
}
