<?php
// navbar.php

session_start();

$user_type = $_SESSION['user_type'] ?? '';

?>
<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
    <a class="navbar-brand" href="#">Forex CRM</a>
    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarNav">
        <ul class="navbar-nav">
            <?php if ($user_type == 'admin'): ?>
                <li class="nav-item"><a class="nav-link" href="../admin/dashboard.php">Admin Dashboard</a></li>
                <li class="nav-item"><a class="nav-link" href="../admin/manage_users.php">Manage Users</a></li>
                <li class="nav-item"><a class="nav-link" href="../admin/manage_ibs.php">Manage IBs</a></li>
                <li class="nav-item"><a class="nav-link" href="../admin/trade_report.php">Trade Report</a></li>
            <?php elseif ($user_type == 'ib'): ?>
                <li class="nav-item"><a class="nav-link" href="../ib/index.php">IB Dashboard</a></li>
                <li class="nav-item"><a class="nav-link" href="../ib/commissions.php">Commissions</a></li>
                <li class="nav-item"><a class="nav-link" href="../user/profile.php">Profile</a></li>
            <?php elseif ($user_type == 'user'): ?>
                <li class="nav-item"><a class="nav-link" href="../user/index.php">User Dashboard</a></li>
                <li class="nav-item"><a class="nav-link" href="../user/wallet.php">Wallet</a></li>
                <li class="nav-item"><a class="nav-link" href="../user/trades.php">Trade History</a></li>
                <li class="nav-item"><a class="nav-link" href="../user/profile.php">Profile</a></li>
            <?php endif; ?>
            <li class="nav-item"><a class="nav-link" href="../public/logout.php">Logout</a></li>
        </ul>
    </div>
</nav>