<?php
// login.php

include('../includes/db.php');
include('../includes/header.php');
require '../vendor/autoload.php'; // PHPMailer

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

session_start();

// Handle login
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['username']) && isset($_POST['password'])) {
    $username = $_POST['username'];
    $password = $_POST['password'];

    // Fetch user by username
    $stmt = $pdo->prepare("SELECT * FROM users WHERE username = :username");
    $stmt->execute(['username' => $username]);
    $user = $stmt->fetch();

    if ($user && password_verify($password, $user['password'])) {
        // Set up two-step verification via email
        $verification_code = rand(100000, 999999);
        $_SESSION['verification_code'] = $verification_code;
        $_SESSION['temp_user_id'] = $user['id'];

        // Send verification email
        $mail = new PHPMailer(true);
        try {
            $mail->setFrom('noreply@forexcrm.com', 'Forex CRM');
            $mail->addAddress($user['email']);
            $mail->isHTML(true);
            $mail->Subject = 'Two-Step Verification Code';
            $mail->Body = "Your verification code is: <strong>$verification_code</strong>";
            $mail->send();
        } catch (Exception $e) {
            $error = "Error sending verification email.";
        }

        header("Location: verify.php");
        exit();
    } else {
        $error = "Invalid username or password.";
    }
}

?>

<div class="container mt-5">
    <h1>Login</h1>
    <?php if (isset($error)) echo "<div class='alert alert-danger'>$error</div>"; ?>
    <form method="POST" action="">
        <div class="form-group">
            <label for="username">Username:</label>
            <input type="text" name="username" class="form-control" required>
        </div>
        <div class="form-group">
            <label for="password">Password:</label>
            <input type="password" name="password" class="form-control" required>
        </div>
        <input type="submit" value="Login" class="btn btn-primary">
    </form>
</div>

<?php include('../includes/footer.php'); ?>