<?php
// new_password.php

include('../includes/db.php');
include('../includes/header.php');

$token = $_GET['token'] ?? null;

if (!$token) {
    header("Location: reset_password.php");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $password = password_hash($_POST['password'], PASSWORD_BCRYPT);

    // Update password for the given token
    $stmt = $pdo->prepare("UPDATE users SET password = :password, reset_token = NULL, token_expiration = NULL WHERE reset_token = :token AND token_expiration > NOW()");
    $stmt->execute(['password' => $password, 'token' => $token]);

    if ($stmt->rowCount() > 0) {
        $success = "Password updated successfully. You can now login.";
    } else {
        $error = "Invalid or expired token.";
    }
}
?>

<div class="container mt-5">
    <h1>New Password</h1>
    <?php if (isset($success)) echo "<div class='alert alert-success'>$success</div>"; ?>
    <?php if (isset($error)) echo "<div class='alert alert-danger'>$error</div>"; ?>
    <form method="POST" action="">
        <div class="form-group">
            <label for="password">New Password:</label>
            <input type="password" name="password" class="form-control" required>
        </div>
        <input type="submit" value="Update Password" class="btn btn-primary">
    </form>
</div>

<?php include('../includes/footer.php'); ?>