<?php
// otp_verification.php

session_start();
include('../includes/db.php');
include('../includes/header.php');

if (!isset($_SESSION['user_id']) || $_SESSION['otp_verified'] === true) {
    header("Location: login.php");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $entered_otp = $_POST['otp'];

    if ($entered_otp == $_SESSION['otp']) {
        $_SESSION['otp_verified'] = true;
        $user_type = $_SESSION['user_type'];
        if ($user_type == 'admin') {
            header("Location: ../admin/dashboard.php");
        } elseif ($user_type == 'user') {
            header("Location: ../user/index.php");
        } elseif ($user_type == 'ib') {
            header("Location: ../ib/index.php");
        }
        exit();
    } else {
        $error = "Invalid OTP. Please try again.";
    }
}
?>

<div class="container mt-5">
    <h1>OTP Verification</h1>
    <?php if (isset($error)) echo "<div class='alert alert-danger'>$error</div>"; ?>
    <form method="POST" action="">
        <div class="form-group">
            <label for="otp">Enter OTP:</label>
            <input type="text" name="otp" class="form-control" required>
        </div>
        <input type="submit" value="Verify OTP" class="btn btn-primary">
    </form>
</div>

<?php include('../includes/footer.php'); ?>