<?php
// register.php

include('../includes/db.php');
include('../includes/header.php');
require '../vendor/autoload.php'; // PHPMailer

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = $_POST['username'];
    $email = $_POST['email'];
    $password = password_hash($_POST['password'], PASSWORD_BCRYPT);
    $verification_code = bin2hex(random_bytes(16));

    // Insert user into the database with verification code
    $stmt = $pdo->prepare("INSERT INTO users (username, email, password, verification_code, verified, created_at) VALUES (:username, :email, :password, :verification_code, 0, NOW())");
    $stmt->execute([
        'username' => $username,
        'email' => $email,
        'password' => $password,
        'verification_code' => $verification_code,
    ]);

    // Send verification email
    $mail = new PHPMailer(true);
    try {
        $mail->setFrom('noreply@forexcrm.com', 'Forex CRM');
        $mail->addAddress($email);
        $mail->isHTML(true);
        $mail->Subject = 'Account Verification';
        $mail->Body = "Click the link to verify your account: <a href='http://localhost/public/verify.php?code=$verification_code'>Verify Account</a>";

        $mail->send();
        $success = "Registration successful! A verification link has been sent to your email.";
    } catch (Exception $e) {
        $error = "Error sending verification email.";
    }
}
?>

<div class="container mt-5">
    <h1>Register</h1>
    <?php if (isset($success)) echo "<div class='alert alert-success'>$success</div>"; ?>
    <?php if (isset($error)) echo "<div class='alert alert-danger'>$error</div>"; ?>
    <form method="POST" action="">
        <div class="form-group">
            <label for="username">Username:</label>
            <input type="text" name="username" class="form-control" required>
        </div>
        <div class="form-group">
            <label for="email">Email:</label>
            <input type="email" name="email" class="form-control" required>
        </div>
        <div class="form-group">
            <label for="password">Password:</label>
            <input type="password" name="password" class="form-control" required>
        </div>
        <input type="submit" value="Register" class="btn btn-primary">
    </form>
</div>

<?php include('../includes/footer.php'); ?>