<?php
// reset_password.php

include('../includes/db.php');
include('../includes/header.php');
require '../vendor/autoload.php'; // PHPMailer

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email = $_POST['email'];

    // Verify email existence in the system
    $stmt = $pdo->prepare("SELECT * FROM users WHERE email = :email");
    $stmt->execute(['email' => $email]);
    $user = $stmt->fetch();

    if ($user) {
        // Generate reset token
        $token = bin2hex(random_bytes(50));
        $stmt = $pdo->prepare("UPDATE users SET reset_token = :token, token_expiration = DATE_ADD(NOW(), INTERVAL 1 HOUR) WHERE email = :email");
        $stmt->execute(['token' => $token, 'email' => $email]);

        // Send reset link via email
        $mail = new PHPMailer(true);
        try {
            $mail->setFrom('noreply@forexcrm.com', 'Forex CRM');
            $mail->addAddress($user['email']);
            $mail->isHTML(true);
            $mail->Subject = 'Password Reset Request';
            $mail->Body = "Click the link to reset your password: <a href='http://localhost/public/new_password.php?token=$token'>Reset Password</a>";

            $mail->send();
            $success = "A reset link has been sent to your email.";
        } catch (Exception $e) {
            $error = "Error sending reset email.";
        }
    } else {
        $error = "Email not found.";
    }
}
?>

<div class="container mt-5">
    <h1>Reset Password</h1>
    <?php if (isset($success)) echo "<div class='alert alert-success'>$success</div>"; ?>
    <?php if (isset($error)) echo "<div class='alert alert-danger'>$error</div>"; ?>
    <form method="POST" action="">
        <div class="form-group">
            <label for="email">Enter your email:</label>
            <input type="email" name="email" class="form-control" required>
        </div>
        <input type="submit" value="Send Reset Link" class="btn btn-primary">
    </form>
</div>

<?php include('../includes/footer.php'); ?>