<?php
// verify.php

include('../includes/db.php');
include('../includes/header.php');
session_start();

if (!isset($_SESSION['temp_user_id'])) {
    header("Location: login.php");
    exit();
}

// Handle verification code submission
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['verification_code'])) {
    $entered_code = $_POST['verification_code'];

    if ($entered_code == $_SESSION['verification_code']) {
        $_SESSION['user_id'] = $_SESSION['temp_user_id'];
        unset($_SESSION['verification_code']);
        unset($_SESSION['temp_user_id']);
        header("Location: ../user/dashboard.php");
        exit();
    } else {
        $error = "Invalid verification code.";
    }
}

?>

<div class="container mt-5">
    <h1>Verify Your Account</h1>
    <?php if (isset($error)) echo "<div class='alert alert-danger'>$error</div>"; ?>
    <form method="POST" action="">
        <div class="form-group">
            <label for="verification_code">Verification Code:</label>
            <input type="text" name="verification_code" class="form-control" required>
        </div>
        <input type="submit" value="Verify" class="btn btn-primary">
    </form>
</div>

<?php include('../includes/footer.php'); ?>