<?php
// contact_support.php

include('../includes/db.php');
include('../includes/header.php');
include('../includes/navbar.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'user') {
    header("Location: ../public/login.php");
    exit();
}

$user_id = $_SESSION['user_id'];

// Handle support message submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $message = $_POST['message'];

    $stmt = $pdo->prepare("INSERT INTO support_messages (user_id, message, sent_at) VALUES (:user_id, :message, NOW())");
    $stmt->execute([
        'user_id' => $user_id,
        'message' => $message,
    ]);

    $success = "Your message has been sent to support.";
}

// Fetch user messages
$stmt = $pdo->prepare("SELECT * FROM support_messages WHERE user_id = :user_id ORDER BY sent_at DESC");
$stmt->execute(['user_id' => $user_id]);
$messages = $stmt->fetchAll();

?>

<div class="container mt-5">
    <h1>Contact Support</h1>
    <?php if (isset($success)) echo "<div class='alert alert-success'>$success</div>"; ?>
    <form method="POST" action="">
        <div class="form-group">
            <label for="message">Message:</label>
            <textarea name="message" class="form-control" rows="5" required></textarea>
        </div>
        <input type="submit" value="Send Message" class="btn btn-primary">
    </form>
    <hr>
    <h2>Your Messages</h2>
    <table class="table table-bordered mt-3">
        <thead>
            <tr>
                <th>Message</th>
                <th>Sent At</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($messages as $msg): ?>
                <tr>
                    <td><?php echo $msg['message']; ?></td>
                    <td><?php echo $msg['sent_at']; ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php include('../includes/footer.php'); ?>