<?php
// dashboard.php

include('../includes/db.php');
include('../includes/header.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'user') {
    header("Location: ../public/login.php");
    exit();
}

$user_id = $_SESSION['user_id'];

// Fetch user data
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = :user_id");
$stmt->execute(['user_id' => $user_id]);
$user = $stmt->fetch();

// Fetch recent trades
$stmt_trades = $pdo->prepare("SELECT * FROM trades WHERE user_id = :user_id ORDER BY trade_date DESC LIMIT 5");
$stmt_trades->execute(['user_id' => $user_id]);
$recent_trades = $stmt_trades->fetchAll();

// Determine user tier based on wallet balance
$tier = 'Bronze';
if ($user['wallet_balance'] >= 10000) {
    $tier = 'Gold';
} elseif ($user['wallet_balance'] >= 5000) {
    $tier = 'Silver';
}

?>

<div class="container mt-5">
    <h1 class="text-center">Welcome, <?php echo $user['username']; ?>!</h1>
    <div class="row mt-4">
        <!-- Wallet Balance Card -->
        <div class="col-md-4">
            <div class="card text-white bg-primary mb-3">
                <div class="card-body">
                    <h5 class="card-title">Wallet Balance</h5>
                    <p class="card-text">$<?php echo number_format($user['wallet_balance'], 2); ?></p>
                </div>
            </div>
        </div>
        <!-- User Tier Card -->
        <div class="col-md-4">
            <div class="card text-white bg-info mb-3">
                <div class="card-body">
                    <h5 class="card-title">Your Tier</h5>
                    <p class="card-text"><?php echo $tier; ?></p>
                </div>
            </div>
        </div>
        <!-- Active Alerts Card -->
        <div class="col-md-4">
            <div class="card text-white bg-warning mb-3">
                <div class="card-body">
                    <h5 class="card-title">Active Trade Alerts</h5>
                    <p class="card-text">
                        <?php
                        $stmt_alerts = $pdo->prepare("SELECT COUNT(*) as alert_count FROM trade_alerts WHERE user_id = :user_id");
                        $stmt_alerts->execute(['user_id' => $user_id]);
                        $alert_count = $stmt_alerts->fetchColumn();
                        echo $alert_count;
                        ?>
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Trades Table -->
    <div class="mt-5">
        <h3>Recent Trades</h3>
        <table class="table table-striped">
            <thead>
                <tr>
                    <th>Trade Type</th>
                    <th>Currency Pair</th>
                    <th>Amount</th>
                    <th>Profit/Loss</th>
                    <th>Trade Date</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($recent_trades as $trade): ?>
                    <tr>
                        <td><?php echo ucfirst($trade['trade_type']); ?></td>
                        <td><?php echo $trade['currency_pair']; ?></td>
                        <td>$<?php echo $trade['amount']; ?></td>
                        <td>$<?php echo $trade['profit_loss']; ?></td>
                        <td><?php echo $trade['trade_date']; ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <!-- Progress Bar for User Tier Advancement -->
    <div class="mt-5">
        <h3>Progress to Next Tier</h3>
        <div class="progress">
            <?php
            $progress = min(100, ($user['wallet_balance'] / 10000) * 100);
            ?>
            <div class="progress-bar bg-success" role="progressbar" style="width: <?php echo $progress; ?>%" aria-valuenow="<?php echo $progress; ?>" aria-valuemin="0" aria-valuemax="100"><?php echo round($progress); ?>%</div>
        </div>
    </div>
</div>

<?php include('../includes/footer.php'); ?>