<?php
// delete_account.php

include('../includes/db.php');
include('../includes/header.php');
include('../includes/navbar.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'user') {
    header("Location: ../public/login.php");
    exit();
}

$user_id = $_SESSION['user_id'];

// Handle account deletion request
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $stmt = $pdo->prepare("INSERT INTO account_deletion_requests (user_id, status, requested_at) VALUES (:user_id, 'pending', NOW())");
    $stmt->execute(['user_id' => $user_id]);

    $success = "Your account deletion request has been submitted successfully. It is now pending admin approval.";
}

?>

<div class="container mt-5">
    <h1>Account Deletion Request</h1>
    <?php if (isset($success)) echo "<div class='alert alert-success'>$success</div>"; ?>
    <p>If you wish to delete your account, please click the button below to submit a request. This action will be reviewed by an admin, and you will be notified of the outcome.</p>
    <form method="POST" action="">
        <input type="submit" value="Request Account Deletion" class="btn btn-danger">
    </form>
</div>

<?php include('../includes/footer.php'); ?>