<?php
// email_preferences.php

include('../includes/db.php');
include('../includes/header.php');
include('../includes/navbar.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'user') {
    header("Location: ../public/login.php");
    exit();
}

$user_id = $_SESSION['user_id'];

// Handle email preferences update
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $trade_notifications = isset($_POST['trade_notifications']) ? 1 : 0;
    $withdrawal_notifications = isset($_POST['withdrawal_notifications']) ? 1 : 0;
    $announcement_notifications = isset($_POST['announcement_notifications']) ? 1 : 0;

    $stmt = $pdo->prepare("UPDATE users SET trade_notifications = :trade_notifications, withdrawal_notifications = :withdrawal_notifications, announcement_notifications = :announcement_notifications WHERE id = :user_id");
    $stmt->execute([
        'trade_notifications' => $trade_notifications,
        'withdrawal_notifications' => $withdrawal_notifications,
        'announcement_notifications' => $announcement_notifications,
        'user_id' => $user_id,
    ]);

    $success = "Email preferences updated successfully.";
}

// Fetch current email preferences
$stmt = $pdo->prepare("SELECT trade_notifications, withdrawal_notifications, announcement_notifications FROM users WHERE id = :user_id");
$stmt->execute(['user_id' => $user_id]);
$user_preferences = $stmt->fetch();

?>

<div class="container mt-5">
    <h1>Email Notification Preferences</h1>
    <?php if (isset($success)) echo "<div class='alert alert-success'>$success</div>"; ?>
    <form method="POST" action="">
        <div class="form-check">
            <input type="checkbox" class="form-check-input" name="trade_notifications" id="trade_notifications" <?php echo $user_preferences['trade_notifications'] ? 'checked' : ''; ?>>
            <label class="form-check-label" for="trade_notifications">Receive trade notifications</label>
        </div>
        <div class="form-check">
            <input type="checkbox" class="form-check-input" name="withdrawal_notifications" id="withdrawal_notifications" <?php echo $user_preferences['withdrawal_notifications'] ? 'checked' : ''; ?>>
            <label class="form-check-label" for="withdrawal_notifications">Receive withdrawal notifications</label>
        </div>
        <div class="form-check">
            <input type="checkbox" class="form-check-input" name="announcement_notifications" id="announcement_notifications" <?php echo $user_preferences['announcement_notifications'] ? 'checked' : ''; ?>>
            <label class="form-check-label" for="announcement_notifications">Receive announcements</label>
        </div>
        <input type="submit" value="Update Preferences" class="btn btn-primary mt-3">
    </form>
</div>

<?php include('../includes/footer.php'); ?>