<?php
// export_data.php

include('../includes/db.php');
include('../includes/header.php');
include('../includes/navbar.php');
require '../vendor/autoload.php'; // PhpSpreadsheet

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'user') {
    header("Location: ../public/login.php");
    exit();
}

$user_id = $_SESSION['user_id'];

// Fetch user data
$stmt_user = $pdo->prepare("SELECT * FROM users WHERE id = :user_id");
$stmt_user->execute(['user_id' => $user_id]);
$user = $stmt_user->fetch();

// Fetch trades
$stmt_trades = $pdo->prepare("SELECT * FROM trades WHERE user_id = :user_id");
$stmt_trades->execute(['user_id' => $user_id]);
$trades = $stmt_trades->fetchAll();

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['export'])) {
    // Create an Excel file with user data
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();

    // Set user data header
    $sheet->setCellValue('A1', 'User Data');
    $sheet->setCellValue('A3', 'Username');
    $sheet->setCellValue('B3', 'Email');
    $sheet->setCellValue('C3', 'First Name');
    $sheet->setCellValue('D3', 'Last Name');
    $sheet->setCellValue('E3', 'Wallet Balance');

    // Add user data
    $sheet->setCellValue('A4', $user['username']);
    $sheet->setCellValue('B4', $user['email']);
    $sheet->setCellValue('C4', $user['first_name']);
    $sheet->setCellValue('D4', $user['last_name']);
    $sheet->setCellValue('E4', $user['wallet_balance']);

    // Add trades data
    $sheet->setCellValue('A6', 'Trades');
    $sheet->setCellValue('A8', 'Trade ID');
    $sheet->setCellValue('B8', 'Trade Type');
    $sheet->setCellValue('C8', 'Currency Pair');
    $sheet->setCellValue('D8', 'Amount');
    $sheet->setCellValue('E8', 'Profit/Loss');
    $sheet->setCellValue('F8', 'Trade Date');

    $rowIndex = 9;
    foreach ($trades as $trade) {
        $sheet->setCellValue('A' . $rowIndex, $trade['id']);
        $sheet->setCellValue('B' . $rowIndex, $trade['trade_type']);
        $sheet->setCellValue('C' . $rowIndex, $trade['currency_pair']);
        $sheet->setCellValue('D' . $rowIndex, $trade['amount']);
        $sheet->setCellValue('E' . $rowIndex, $trade['profit_loss']);
        $sheet->setCellValue('F' . $rowIndex, $trade['trade_date']);
        $rowIndex++;
    }

    // Output Excel file
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="user_data.xlsx"');
    $writer = new Xlsx($spreadsheet);
    $writer->save('php://output');
    exit();
}

?>

<div class="container mt-5">
    <h1>Export Personal Data</h1>
    <form method="POST" action="">
        <input type="hidden" name="export" value="1">
        <input type="submit" value="Export Data as Excel" class="btn btn-primary">
    </form>
</div>

<?php include('../includes/footer.php'); ?>