<?php
// user/index.php

include('../includes/db.php');
include('../includes/header.php');
include('../includes/navbar.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'user') {
    header("Location: ../public/login.php");
    exit();
}

$user_id = $_SESSION['user_id'];

// Fetch user wallet balance
$stmt = $pdo->prepare("SELECT wallet_balance FROM users WHERE id = :user_id");
$stmt->execute(['user_id' => $user_id]);
$wallet_balance = $stmt->fetchColumn();

?>

<div class="container mt-5">
    <h1>User Dashboard</h1>
    <div class="row mt-4" id="widget-container">
        <div class="col-md-4 widget" data-widget-id="balance">
            <div class="card text-white bg-primary mb-3">
                <div class="card-body">
                    <h5 class="card-title">Wallet Balance</h5>
                    <p class="card-text">$<?php echo $wallet_balance; ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-4 widget" data-widget-id="trades">
            <div class="card text-white bg-success mb-3">
                <div class="card-body">
                    <h5 class="card-title">Total Trades</h5>
                    <p class="card-text">You have executed <?php // fetch number of trades 
                                                            ?> trades.</p>
                </div>
            </div>
        </div>
        <div class="col-md-4 widget" data-widget-id="notifications">
            <div class="card text-white bg-info mb-3">
                <div class="card-body">
                    <h5 class="card-title">Notifications</h5>
                    <p class="card-text">You have <?php // fetch number of unread notifications 
                                                    ?> unread notifications.</p>
                </div>
            </div>
        </div>
    </div>
    <button class="btn btn-secondary" id="save-widgets">Save Widget Layout</button>
</div>

<script>
    // JavaScript for drag and drop widgets
    document.addEventListener('DOMContentLoaded', function() {
        const widgetContainer = document.getElementById('widget-container');

        // Save button handler
        document.getElementById('save-widgets').onclick = function() {
            const widgets = document.querySelectorAll('.widget');
            let widgetOrder = [];
            widgets.forEach(widget => {
                widgetOrder.push(widget.getAttribute('data-widget-id'));
            });
            localStorage.setItem('widgetOrder', JSON.stringify(widgetOrder));
            alert('Widget layout saved.');
        };

        // Load saved widget order
        const savedOrder = JSON.parse(localStorage.getItem('widgetOrder'));
        if (savedOrder) {
            savedOrder.forEach(id => {
                const widget = document.querySelector(`.widget[data-widget-id="${id}"]`);
                if (widget) {
                    widgetContainer.appendChild(widget);
                }
            });
        }
    });
</script>

<?php include('../includes/footer.php'); ?>