<?php
// kyc_verification.php

include('../includes/db.php');
include('../includes/header.php');
include('../includes/navbar.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'user') {
    header("Location: ../public/login.php");
    exit();
}

$user_id = $_SESSION['user_id'];
$kyc_status = 'pending';

// Fetch KYC status for the user
$stmt = $pdo->prepare("SELECT kyc_status FROM users WHERE id = :user_id");
$stmt->execute(['user_id' => $user_id]);
$kyc_status = $stmt->fetchColumn();

// Handle KYC document upload
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_FILES['kyc_document']) && $_FILES['kyc_document']['error'] == UPLOAD_ERR_OK) {
        $document_name = $_FILES['kyc_document']['name'];
        $document_tmp_name = $_FILES['kyc_document']['tmp_name'];
        $document_path = "../uploads/kyc_documents/" . basename($document_name);

        // Save the uploaded document
        if (move_uploaded_file($document_tmp_name, $document_path)) {
            // Update user's KYC status to 'pending' and save document details
            $stmt = $pdo->prepare("UPDATE users SET kyc_status = 'pending', kyc_document = :document_name WHERE id = :user_id");
            $stmt->execute(['document_name' => $document_name, 'user_id' => $user_id]);

            $success = "Document uploaded successfully. Your KYC status is now pending.";
        } else {
            $error = "Failed to upload document. Please try again.";
        }
    } else {
        $error = "Please upload a valid document.";
    }
}

?>

<div class="container mt-5">
    <h1>KYC Verification</h1>
    <p><strong>Current KYC Status:</strong> <?php echo ucfirst($kyc_status); ?></p>
    <?php if (isset($success)) echo "<div class='alert alert-success'>$success</div>"; ?>
    <?php if (isset($error)) echo "<div class='alert alert-danger'>$error</div>"; ?>
    <form method="POST" action="" enctype="multipart/form-data">
        <div class="form-group">
            <label for="kyc_document">Upload Identity Document:</label>
            <input type="file" name="kyc_document" class="form-control" required>
        </div>
        <input type="submit" value="Upload Document" class="btn btn-primary">
    </form>
</div>

<?php include('../includes/footer.php'); ?>