<?php
// profile.php

include('../includes/db.php');
include('../includes/header.php');
include('../includes/navbar.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'user') {
    header("Location: ../public/login.php");
    exit();
}

$user_id = $_SESSION['user_id'];

// Fetch user data including referral code and referral rewards
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = :user_id");
$stmt->execute(['user_id' => $user_id]);
$user = $stmt->fetch();

// Fetch referral rewards
$stmt_rewards = $pdo->prepare("SELECT * FROM referral_rewards WHERE referrer_id = :user_id");
$stmt_rewards->execute(['user_id' => $user_id]);
$referral_rewards = $stmt_rewards->fetchAll();

?>

<div class="container mt-5">
    <h1>User Profile</h1>
    <form method="POST" action="">
        <div class="form-group">
            <label for="first_name">First Name:</label>
            <input type="text" name="first_name" class="form-control" value="<?php echo $user['first_name']; ?>" required>
        </div>
        <div class="form-group">
            <label for="last_name">Last Name:</label>
            <input type="text" name="last_name" class="form-control" value="<?php echo $user['last_name']; ?>" required>
        </div>
        <div class="form-group">
            <label for="phone">Phone:</label>
            <input type="text" name="phone" class="form-control" value="<?php echo $user['phone']; ?>" required>
        </div>
        <input type="submit" value="Update Profile" class="btn btn-primary">
    </form>
    <hr>
    <h2>Your Referral Code: <strong><?php echo $user['referral_code']; ?></strong></h2>
    <h3>Referral Rewards</h3>
    <table class="table table-bordered mt-3">
        <thead>
            <tr>
                <th>Reward Amount</th>
                <th>Date Earned</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($referral_rewards as $reward): ?>
                <tr>
                    <td>$<?php echo $reward['amount']; ?></td>
                    <td><?php echo $reward['earned_at']; ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php include('../includes/footer.php'); ?>