<?php
// security_settings.php

include('../includes/db.php');
include('../includes/header.php');
include('../includes/navbar.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'user') {
    header("Location: ../public/login.php");
    exit();
}

$user_id = $_SESSION['user_id'];

// Handle biometric authentication settings
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['enable_biometrics'])) {
    // Enable biometric authentication (client-side logic will handle the WebAuthn process)
    $stmt = $pdo->prepare("UPDATE users SET biometric_enabled = 1 WHERE id = :user_id");
    $stmt->execute(['user_id' => $user_id]);
    $success = "Biometric authentication enabled successfully.";
}

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['disable_biometrics'])) {
    // Disable biometric authentication
    $stmt = $pdo->prepare("UPDATE users SET biometric_enabled = 0 WHERE id = :user_id");
    $stmt->execute(['user_id' => $user_id]);
    $success = "Biometric authentication disabled successfully.";
}

// Fetch biometric settings
$stmt = $pdo->prepare("SELECT biometric_enabled FROM users WHERE id = :user_id");
$stmt->execute(['user_id' => $user_id]);
$biometric_enabled = $stmt->fetchColumn();

?>

<div class="container mt-5">
    <h1>Security Settings</h1>
    <?php if (isset($success)) echo "<div class='alert alert-success'>$success</div>"; ?>
    <h3>Biometric Authentication</h3>
    <?php if ($biometric_enabled): ?>
        <form method="POST" action="">
            <input type="hidden" name="disable_biometrics" value="1">
            <input type="submit" value="Disable Biometric Authentication" class="btn btn-danger">
        </form>
    <?php else: ?>
        <form method="POST" action="">
            <input type="hidden" name="enable_biometrics" value="1">
            <input type="submit" value="Enable Biometric Authentication" class="btn btn-primary" onclick="enableBiometrics()">
        </form>
    <?php endif; ?>
</div>

<script>
    async function enableBiometrics() {
        try {
            const publicKey = {
                challenge: new Uint8Array(32),
                rp: {
                    name: "Forex CRM"
                },
                user: {
                    id: new Uint8Array(16),
                    name: "<?php echo $_SESSION['username']; ?>",
                    displayName: "<?php echo $_SESSION['username']; ?>"
                },
                pubKeyCredParams: [{
                    alg: -7,
                    type: "public-key"
                }]
            };
            const credential = await navigator.credentials.create({
                publicKey
            });
            console.log(credential);
        } catch (err) {
            console.error(err);
        }
    }
</script>

<?php include('../includes/footer.php'); ?>