<?php
// settings.php

include('../includes/db.php');
include('../includes/header.php');
include('../includes/navbar.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'user') {
    header("Location: ../public/login.php");
    exit();
}

$user_id = $_SESSION['user_id'];

// Handle dark mode toggle
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['dark_mode'])) {
    $dark_mode = $_POST['dark_mode'] == 'enable' ? 1 : 0;

    $stmt = $pdo->prepare("UPDATE users SET dark_mode = :dark_mode WHERE id = :user_id");
    $stmt->execute(['dark_mode' => $dark_mode, 'user_id' => $user_id]);

    $_SESSION['dark_mode'] = $dark_mode;
    header("Location: settings.php");
    exit();
}

// Fetch user's dark mode preference
$stmt = $pdo->prepare("SELECT dark_mode FROM users WHERE id = :user_id");
$stmt->execute(['user_id' => $user_id]);
$dark_mode = $stmt->fetchColumn();

?>

<div class="container mt-5">
    <h1>Settings</h1>
    <form method="POST" action="">
        <h3>Dark Mode</h3>
        <?php if ($dark_mode): ?>
            <input type="hidden" name="dark_mode" value="disable">
            <input type="submit" value="Disable Dark Mode" class="btn btn-light">
        <?php else: ?>
            <input type="hidden" name="dark_mode" value="enable">
            <input type="submit" value="Enable Dark Mode" class="btn btn-dark">
        <?php endif; ?>
    </form>
</div>

<?php include('../includes/footer.php'); ?>