<?php
// support_ticket.php

include('../includes/db.php');
include('../includes/header.php');
include('../includes/navbar.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'user') {
    header("Location: ../public/login.php");
    exit();
}

$user_id = $_SESSION['user_id'];

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $subject = $_POST['subject'];
    $message = $_POST['message'];

    // Insert support ticket
    $stmt = $pdo->prepare("INSERT INTO support_tickets (user_id, subject, message, status, created_at) VALUES (:user_id, :subject, :message, 'open', NOW())");
    $stmt->execute([
        'user_id' => $user_id,
        'subject' => $subject,
        'message' => $message,
    ]);

    $success = "Your support request has been submitted successfully.";
}

// Fetch user's support tickets
$stmt = $pdo->prepare("SELECT * FROM support_tickets WHERE user_id = :user_id ORDER BY created_at DESC");
$stmt->execute(['user_id' => $user_id]);
$tickets = $stmt->fetchAll();

?>

<div class="container mt-5">
    <h1>Support & Feedback</h1>
    <?php if (isset($success)) echo "<div class='alert alert-success'>$success</div>"; ?>
    <form method="POST" action="">
        <div class="form-group">
            <label for="subject">Subject:</label>
            <input type="text" name="subject" class="form-control" required>
        </div>
        <div class="form-group">
            <label for="message">Message:</label>
            <textarea name="message" class="form-control" rows="5" required></textarea>
        </div>
        <input type="submit" value="Submit" class="btn btn-primary">
    </form>
    <hr>
    <h2>Your Support Tickets</h2>
    <table class="table table-bordered mt-3">
        <thead>
            <tr>
                <th>ID</th>
                <th>Subject</th>
                <th>Message</th>
                <th>Status</th>
                <th>Created At</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($tickets as $ticket): ?>
                <tr>
                    <td><?php echo $ticket['id']; ?></td>
                    <td><?php echo $ticket['subject']; ?></td>
                    <td><?php echo $ticket['message']; ?></td>
                    <td><?php echo ucfirst($ticket['status']); ?></td>
                    <td><?php echo $ticket['created_at']; ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php include('../includes/footer.php'); ?>