<?php
// trades.php

include('../includes/db.php');
include('../includes/header.php');
include('../includes/navbar.php');
require '../vendor/autoload.php'; // DOMPDF

use Dompdf\Dompdf;

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'user') {
    header("Location: ../public/login.php");
    exit();
}

$user_id = $_SESSION['user_id'];

// Fetch user trades
$stmt = $pdo->prepare("SELECT * FROM trades WHERE user_id = :user_id");
$stmt->execute(['user_id' => $user_id]);
$trades = $stmt->fetchAll();

// PDF export logic
if (isset($_GET['export']) && $_GET['export'] == 'pdf') {
    $dompdf = new Dompdf();
    ob_start();
    include('trades_pdf_template.php');
    $html = ob_get_clean();
    $dompdf->loadHtml($html);
    $dompdf->setPaper('A4', 'landscape');
    $dompdf->render();
    $dompdf->stream("trade_history.pdf", ["Attachment" => true]);
    exit();
}

?>

<div class="container mt-5">
    <h1>Trade History</h1>
    <a href="?export=pdf" class="btn btn-primary mb-3">Export as PDF</a>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>ID</th>
                <th>Trade Type</th>
                <th>Currency Pair</th>
                <th>Amount</th>
                <th>Profit/Loss</th>
                <th>Trade Date</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($trades as $trade): ?>
                <tr>
                    <td><?php echo $trade['id']; ?></td>
                    <td><?php echo $trade['trade_type']; ?></td>
                    <td><?php echo $trade['currency_pair']; ?></td>
                    <td>$<?php echo $trade['amount']; ?></td>
                    <td>$<?php echo $trade['profit_loss']; ?></td>
                    <td><?php echo $trade['trade_date']; ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php include('../includes/footer.php'); ?>